// client/composables/voice-sfu/env.js

export const Env = {
    detectDevice() {
        const ua = navigator.userAgent
        if (/android/i.test(ua)) return 'android'
        if (/iPad|iPhone|iPod/.test(ua)) return 'ios'
        if (/Windows|Macintosh|Linux/.test(ua)) return 'desktop'
        return 'unknown'
    },

    isIOS() {
        return (
            /iPad|iPhone|iPod/.test(navigator.userAgent) ||
            (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1)
        )
    },

    isAndroid() {
        return /android/i.test(navigator.userAgent)
    }
}
