// client/composables/voice-sfu/rpc.js

export function createRpc(socket, logger = console) {
    const askServer = (event, payload = {}, { timeoutMs = 8000 } = {}) =>
        new Promise((resolve, reject) => {
            logger.log('[SFU] -> emit', event, payload)
            let done = false
            const t = setTimeout(() => {
                if (done) return
                done = true
                logger.error('[SFU] !! timeout on', event)
                reject(new Error(`Timeout on ${event}`))
            }, timeoutMs)

            socket.emit(event, payload, (ans) => {
                if (done) return
                done = true
                clearTimeout(t)
                logger.log('[SFU] <- ack', event, ans)
                resolve(ans)
            })
        })

    return { askServer }
}
