// client/composables/voice-sfu/meter.js
export function createMeterModule({
                                      AudioModule,
                                      speakingMapRef,
                                      volumeMapRef,
                                      myIdRef,
                                      socket,     // 👈 اضافه شد
                                      roomId,     // 👈 اضافه شد
                                      logger = console
                                  }) {
    let meterRAF = null
    let meterAnalyser = null
    let meterSrc = null

    // throttle برای جلوگیری از flood
    let lastEmit = 0
    const EMIT_INTERVAL = 2000 // ms

    const startLocalMeter = (stream) => {
        const audioCtx = AudioModule.getCtx()
        logger.log('[SFU] startLocalMeter called', { hasCtx: !!audioCtx })
        try {
            if (!audioCtx || !stream) return

            // اگر از قبل فعال بوده، جمع کن
            if (meterRAF) cancelAnimationFrame(meterRAF)
            try { meterSrc && meterSrc.disconnect() } catch {}
            try { meterAnalyser && meterAnalyser.disconnect && meterAnalyser.disconnect() } catch {}

            meterAnalyser = audioCtx.createAnalyser()
            meterAnalyser.fftSize = 2048
            meterAnalyser.smoothingTimeConstant = 0.8

            meterSrc = audioCtx.createMediaStreamSource(stream)
            meterSrc.connect(meterAnalyser)

            const data = new Float32Array(meterAnalyser.fftSize)

            const loop = () => {
                meterAnalyser.getFloatTimeDomainData(data)
                let sum = 0
                for (let i = 0; i < data.length; i++) sum += data[i] * data[i]
                const rms = Math.sqrt(sum / data.length)
                const vol = Math.min(100, Math.max(0, Math.round(rms * 1000)))
                const isSpeaking = vol >= 6

                const uid = myIdRef?.value
                if (uid) {
                    // آپدیت لوکال برای خودِ اسپیکر
                    speakingMapRef.value = { ...speakingMapRef.value, [uid]: isSpeaking }
                    volumeMapRef.value   = { ...volumeMapRef.value,   [uid]: vol }

                    // ارسال به سرور (throttled)
                    const now = (typeof performance !== 'undefined' && performance.now) ? performance.now() : Date.now()
                    if (socket && roomId && now - lastEmit >= EMIT_INTERVAL) {
                        socket.emit('speaking', {
                            room: roomId,
                            userId: uid,
                            speaking: isSpeaking,
                            volume: vol
                        })
                        lastEmit = now
                    }
                }

                meterRAF = requestAnimationFrame(loop)
            }

            meterRAF = requestAnimationFrame(loop)
            logger.log('[SFU] local meter started')
        } catch (e) {
            logger.error('[SFU] startLocalMeter error', e)
        }
    }

    const stopLocalMeter = () => {
        logger.log('[SFU] stopLocalMeter')
        if (meterRAF) cancelAnimationFrame(meterRAF)
        meterRAF = null
        try { meterSrc && meterSrc.disconnect() } catch {}
        try { meterAnalyser && meterAnalyser.disconnect && meterAnalyser.disconnect() } catch {}
        meterSrc = null
        meterAnalyser = null

        // سیگنال خاموشی برای سرور (اختیاری ولی مفید)
        const uid = myIdRef?.value
        if (socket && roomId && uid) {
            socket.emit('speaking', { room: roomId, userId: uid, speaking: false, volume: 0 })
        }
    }

    return { startLocalMeter, stopLocalMeter }
}
